// you MUST have these variables.
const ONKEYDOWN	= 0;
const ONKEYUP		= 1;
const ONKEYPRESS	= 2;

var KeyHandler = {
	//KeyLog variables
	keyIDs: new Array(),
	//Action variables
	size: 0,
	actionKeys: new Array(),
	actionTriggers: new Array(),
	actionFunctions: new Array(),
	
	//==================================
	// KEY METHODS
	//==================================
	/*
	 * Pre-conditions:  A keyID is passed, ie KEY_ENTER, KEY_UP, KEY_A, etc.
	 * Post-conditions: If not already there, adds that keyID to the key array.
	 * 			  Does any existing ONKEYDOWN actions.
	 */
	addKey: function(keyID)
	{
		for(var i in this.keyIDs)
			if(this.keyIDs[i] == keyID)
				return;
		
		this.checkForTriggers(keyID,ONKEYDOWN);
		
		this.keyIDs.push(keyID);
	},
	/*
	 * Pre-conditions:  None.
	 * Post-conditions: Searches through all keys in the array.
	 *			  If there is an unpressed key, run ONKEYUP, if it has one. Delete that key from keyIDs.
	 */
	run: function()
	{
		for(var i=0;i<this.keyIDs.length;i++)
		{
			if(!IsKeyPressed(this.keyIDs[i]))
			{
				this.checkForTriggers(this.keyIDs[i],ONKEYUP);
				
				this.keyIDs.splice(i,1);
			}
			else
			{
				this.checkForTriggers(this.keyIDs[i],ONKEYPRESS);
			}
		}
	},
	/*
	 * Pre-conditions:  keyID (KEY_ENTER, etc), and triggerType (ONKEYPRESS, etc) passed.
	 * Post-conditions: Searches through all keys and trigger types in the arrays.
	 *			  If there is a match, run the correct actionFunctions for it.
	 */
	checkForTriggers: function(keyID, triggerType)
	{
		for(var i=0;i<this.size;i++)
			if(keyID == this.actionKeys[i] && triggerType == this.actionTriggers[i])
				this.actionFunctions[i]();
	},
	//==================================
	// ACTION METHODS
	//==================================
	/*
	 * Pre-conditions:  keyID, triggerType (ONKEYPRESS, etc), and function to use passed.
	 * Post-conditions: increase size var by 1, add keyID to the actionKeys array, add triggerType
	 * 			  to the actionTriggers array , and func to the actionFunctions array.
	 */
	add: function(keyID, triggerType, func)
	{
		this.size++;
		this.actionKeys.push(keyID);
		this.actionTriggers.push(triggerType);
		this.actionFunctions.push(func);
	},
	/*
	 * Pre-conditions:  keyID and triggerType passed.
	 * Post-conditions: Searches through all keys and trigger types in the arrays. If there is a match,
	 *			  decrease size var by 1, remove keyID from the actionKeys array,
	 * 			  and remove triggerType from the actionTriggers array.
	 */
	remove: function(keyID, triggerType) {
		for(var i=0;i<this.size;i++) {
			if(this.actionKeys[i] == keyID && this.actionTriggers[i] == triggerType) {
				this.size--;
				this.actionKeys.splice(i,1);
				this.actionTriggers.splice(i,1);
				this.actionFunctions.splice(i,1);
				break;
			}
		}
	},
	removeAll: function() {
		this.size = 0;
		this.actionKeys = new Array();
		this.actionTriggers = new Array();
		this.actionFunctions = new Array();
	}
};